#ifndef _NPDIALOG_H
#define _NPDIALOG_H

#include "UnityNP.h"
#include "Mutex.h"

namespace UnityPlugin
{
	PRX_EXPORT bool PrxNpIsDialogOpen();
	PRX_EXPORT bool PrxNpDialogsGetLastError(ResultCode* result);
	PRX_EXPORT ErrorCode PrxNpDialogFriendsList();
	PRX_EXPORT ErrorCode PrxNpDialogSharedPlayHistory();
	PRX_EXPORT ErrorCode PrxNpDialogProfile(const unsigned char* npID);
	PRX_EXPORT ErrorCode PrxNpDialogGetResult(struct NpDialogReturn* result);

	typedef enum 
	{
		kNpDlgCanceled,
		kNpDlgOK,
	} NpDialogResult;

	// Structure for returning result when an NP dialog is closed.
	struct NpDialogReturn
	{
		const unsigned char* npID;			// NpID, contains data corresponding to the SceNpID structure, can be used as id when opening profile dialog, messaging, etc.
		int npIDSize;						// Size of the npID byte array.
		// for commerce dialog
		bool plusAllowed;					// returns true if we are now allowed to use plus

		NpDialogResult result;				// Result, 0 = canceled, 1 = ok.
	};

	typedef enum 
	{
		kNpDlgNone,
		kNpDlgFriendsList,
		kNpDlgSharedPlayHistory,
		kNpDlgProfile,
	} NpActiveDialog;

	class NpDialogs
	{
		bool m_Busy;
		bool m_DialogOpen;
		NpActiveDialog m_ActiveDialog;
		SceNpId m_npID;
		NpDialogReturn m_Result;
		ResultCode m_LastResult;

	public:
		NpDialogs();

		bool IsBusy();
		ErrorCode GetLastError() const { return m_LastResult.GetResult(); }
		bool GetLastError(ResultCode* result) const { *result = m_LastResult; return m_LastResult.GetResult() == NP_OK; }
		bool IsDialogOpen() const { return m_DialogOpen; }

		ErrorCode StartFriendsListDialog();
		ErrorCode StartSharedHistoryDialog();
		ErrorCode StartProfileDialog(const unsigned char* npID);
		ErrorCode StartCommerceDialog(int CommerceDialogMode, uint64_t features);
		ErrorCode GetResult(NpDialogReturn* result);
		void Update();

	private:
		bool LoadModules();
		void UpdateFriendsDialog();
		void UpdateSharedPlayHistoryDialog();
		void UpdateProfileDialog();
		void UpdateCommerceDialog();
	};

	extern NpDialogs gNpDialogs;
}

#endif // _SIGNING_H
